<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for motor vehicle report
 */
class Motorvehiclereport extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Export
    public $ExportDoc;

    // Fields
    public $_23;
    public $MDA_id;
    public $Make;
    public $Model;
    public $YearofManufacture;
    public $Colour;
    public $EngineNumber;
    public $ChasisNumber;
    public $CivilianPlateNumber;
    public $GovtPlateNumber;
    public $Custodian_id;
    public $Condition_Of_Asset;
    public $Asset_Status;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'motorvehiclereport';
        $this->TableName = 'motor vehicle report';
        $this->TableType = 'VIEW';

        // Update Table
        $this->UpdateTable = "`motor vehicle report`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // #
        $this->_23 = new DbField('motorvehiclereport', 'motor vehicle report', 'x__23', '#', '`#`', '`#`', 20, 21, -1, false, '`#`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->_23->Nullable = false; // NOT NULL field
        $this->_23->Required = true; // Required field
        $this->_23->Sortable = true; // Allow sort
        $this->_23->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_23->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->_23->Param, "CustomMsg");
        $this->Fields['#'] = &$this->_23;

        // MDA_id
        $this->MDA_id = new DbField('motorvehiclereport', 'motor vehicle report', 'x_MDA_id', 'MDA_id', '`MDA_id`', '`MDA_id`', 3, 11, -1, false, '`MDA_id`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->MDA_id->Nullable = false; // NOT NULL field
        $this->MDA_id->Required = true; // Required field
        $this->MDA_id->Sortable = true; // Allow sort
        $this->MDA_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MDA_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_id->Param, "CustomMsg");
        $this->Fields['MDA_id'] = &$this->MDA_id;

        // Make
        $this->Make = new DbField('motorvehiclereport', 'motor vehicle report', 'x_Make', 'Make', '`Make`', '`Make`', 200, 100, -1, false, '`Make`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Make->Sortable = true; // Allow sort
        $this->Make->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Make->Param, "CustomMsg");
        $this->Fields['Make'] = &$this->Make;

        // Model
        $this->Model = new DbField('motorvehiclereport', 'motor vehicle report', 'x_Model', 'Model', '`Model`', '`Model`', 200, 100, -1, false, '`Model`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Model->Sortable = true; // Allow sort
        $this->Model->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Model->Param, "CustomMsg");
        $this->Fields['Model'] = &$this->Model;

        // Year of Manufacture
        $this->YearofManufacture = new DbField('motorvehiclereport', 'motor vehicle report', 'x_YearofManufacture', 'Year of Manufacture', '`Year of Manufacture`', '`Year of Manufacture`', 3, 4, -1, false, '`Year of Manufacture`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->YearofManufacture->Sortable = true; // Allow sort
        $this->YearofManufacture->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->YearofManufacture->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->YearofManufacture->Param, "CustomMsg");
        $this->Fields['Year of Manufacture'] = &$this->YearofManufacture;

        // Colour
        $this->Colour = new DbField('motorvehiclereport', 'motor vehicle report', 'x_Colour', 'Colour', '`Colour`', '`Colour`', 200, 50, -1, false, '`Colour`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Colour->Sortable = true; // Allow sort
        $this->Colour->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Colour->Param, "CustomMsg");
        $this->Fields['Colour'] = &$this->Colour;

        // Engine Number
        $this->EngineNumber = new DbField('motorvehiclereport', 'motor vehicle report', 'x_EngineNumber', 'Engine Number', '`Engine Number`', '`Engine Number`', 200, 100, -1, false, '`Engine Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->EngineNumber->Sortable = true; // Allow sort
        $this->EngineNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->EngineNumber->Param, "CustomMsg");
        $this->Fields['Engine Number'] = &$this->EngineNumber;

        // Chasis Number
        $this->ChasisNumber = new DbField('motorvehiclereport', 'motor vehicle report', 'x_ChasisNumber', 'Chasis Number', '`Chasis Number`', '`Chasis Number`', 200, 100, -1, false, '`Chasis Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->ChasisNumber->Sortable = true; // Allow sort
        $this->ChasisNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->ChasisNumber->Param, "CustomMsg");
        $this->Fields['Chasis Number'] = &$this->ChasisNumber;

        // Civilian Plate Number
        $this->CivilianPlateNumber = new DbField('motorvehiclereport', 'motor vehicle report', 'x_CivilianPlateNumber', 'Civilian Plate Number', '`Civilian Plate Number`', '`Civilian Plate Number`', 200, 20, -1, false, '`Civilian Plate Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->CivilianPlateNumber->Sortable = true; // Allow sort
        $this->CivilianPlateNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->CivilianPlateNumber->Param, "CustomMsg");
        $this->Fields['Civilian Plate Number'] = &$this->CivilianPlateNumber;

        // Govt Plate Number
        $this->GovtPlateNumber = new DbField('motorvehiclereport', 'motor vehicle report', 'x_GovtPlateNumber', 'Govt Plate Number', '`Govt Plate Number`', '`Govt Plate Number`', 200, 20, -1, false, '`Govt Plate Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->GovtPlateNumber->Sortable = true; // Allow sort
        $this->GovtPlateNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->GovtPlateNumber->Param, "CustomMsg");
        $this->Fields['Govt Plate Number'] = &$this->GovtPlateNumber;

        // Custodian_id
        $this->Custodian_id = new DbField('motorvehiclereport', 'motor vehicle report', 'x_Custodian_id', 'Custodian_id', '`Custodian_id`', '`Custodian_id`', 3, 100, -1, false, '`Custodian_id`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Custodian_id->Required = true; // Required field
        $this->Custodian_id->Sortable = true; // Allow sort
        $this->Custodian_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Custodian_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Custodian_id->Param, "CustomMsg");
        $this->Fields['Custodian_id'] = &$this->Custodian_id;

        // Condition_Of_Asset
        $this->Condition_Of_Asset = new DbField('motorvehiclereport', 'motor vehicle report', 'x_Condition_Of_Asset', 'Condition_Of_Asset', '`Condition_Of_Asset`', '`Condition_Of_Asset`', 200, 255, -1, false, '`Condition_Of_Asset`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Condition_Of_Asset->Nullable = false; // NOT NULL field
        $this->Condition_Of_Asset->Required = true; // Required field
        $this->Condition_Of_Asset->Sortable = true; // Allow sort
        $this->Condition_Of_Asset->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Condition_Of_Asset->Param, "CustomMsg");
        $this->Fields['Condition_Of_Asset'] = &$this->Condition_Of_Asset;

        // Asset_Status
        $this->Asset_Status = new DbField('motorvehiclereport', 'motor vehicle report', 'x_Asset_Status', 'Asset_Status', '`Asset_Status`', '`Asset_Status`', 200, 255, -1, false, '`Asset_Status`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Asset_Status->Nullable = false; // NOT NULL field
        $this->Asset_Status->Required = true; // Required field
        $this->Asset_Status->Sortable = true; // Allow sort
        $this->Asset_Status->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Asset_Status->Param, "CustomMsg");
        $this->Fields['Asset_Status'] = &$this->Asset_Status;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        } else {
            $fld->setSort("");
        }
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`motor vehicle report`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    protected function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->_23->DbValue = $row['#'];
        $this->MDA_id->DbValue = $row['MDA_id'];
        $this->Make->DbValue = $row['Make'];
        $this->Model->DbValue = $row['Model'];
        $this->YearofManufacture->DbValue = $row['Year of Manufacture'];
        $this->Colour->DbValue = $row['Colour'];
        $this->EngineNumber->DbValue = $row['Engine Number'];
        $this->ChasisNumber->DbValue = $row['Chasis Number'];
        $this->CivilianPlateNumber->DbValue = $row['Civilian Plate Number'];
        $this->GovtPlateNumber->DbValue = $row['Govt Plate Number'];
        $this->Custodian_id->DbValue = $row['Custodian_id'];
        $this->Condition_Of_Asset->DbValue = $row['Condition_Of_Asset'];
        $this->Asset_Status->DbValue = $row['Asset_Status'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("motorvehiclereportlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "motorvehiclereportview") {
            return $Language->phrase("View");
        } elseif ($pageName == "motorvehiclereportedit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "motorvehiclereportadd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "MotorvehiclereportView";
            case Config("API_ADD_ACTION"):
                return "MotorvehiclereportAdd";
            case Config("API_EDIT_ACTION"):
                return "MotorvehiclereportEdit";
            case Config("API_DELETE_ACTION"):
                return "MotorvehiclereportDelete";
            case Config("API_LIST_ACTION"):
                return "MotorvehiclereportList";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "motorvehiclereportlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("motorvehiclereportview", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("motorvehiclereportview", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "motorvehiclereportadd?" . $this->getUrlParm($parm);
        } else {
            $url = "motorvehiclereportadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("motorvehiclereportedit", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("motorvehiclereportadd", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("motorvehiclereportdelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->_23->setDbValue($row['#']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->Make->setDbValue($row['Make']);
        $this->Model->setDbValue($row['Model']);
        $this->YearofManufacture->setDbValue($row['Year of Manufacture']);
        $this->Colour->setDbValue($row['Colour']);
        $this->EngineNumber->setDbValue($row['Engine Number']);
        $this->ChasisNumber->setDbValue($row['Chasis Number']);
        $this->CivilianPlateNumber->setDbValue($row['Civilian Plate Number']);
        $this->GovtPlateNumber->setDbValue($row['Govt Plate Number']);
        $this->Custodian_id->setDbValue($row['Custodian_id']);
        $this->Condition_Of_Asset->setDbValue($row['Condition_Of_Asset']);
        $this->Asset_Status->setDbValue($row['Asset_Status']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // #

        // MDA_id

        // Make

        // Model

        // Year of Manufacture

        // Colour

        // Engine Number

        // Chasis Number

        // Civilian Plate Number

        // Govt Plate Number

        // Custodian_id

        // Condition_Of_Asset

        // Asset_Status

        // #
        $this->_23->ViewValue = $this->_23->CurrentValue;
        $this->_23->ViewValue = FormatNumber($this->_23->ViewValue, 0, -2, -2, -2);
        $this->_23->ViewCustomAttributes = "";

        // MDA_id
        $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
        $this->MDA_id->ViewValue = FormatNumber($this->MDA_id->ViewValue, 0, -2, -2, -2);
        $this->MDA_id->ViewCustomAttributes = "";

        // Make
        $this->Make->ViewValue = $this->Make->CurrentValue;
        $this->Make->ViewCustomAttributes = "";

        // Model
        $this->Model->ViewValue = $this->Model->CurrentValue;
        $this->Model->ViewCustomAttributes = "";

        // Year of Manufacture
        $this->YearofManufacture->ViewValue = $this->YearofManufacture->CurrentValue;
        $this->YearofManufacture->ViewValue = FormatNumber($this->YearofManufacture->ViewValue, 0, -2, -2, -2);
        $this->YearofManufacture->ViewCustomAttributes = "";

        // Colour
        $this->Colour->ViewValue = $this->Colour->CurrentValue;
        $this->Colour->ViewCustomAttributes = "";

        // Engine Number
        $this->EngineNumber->ViewValue = $this->EngineNumber->CurrentValue;
        $this->EngineNumber->ViewCustomAttributes = "";

        // Chasis Number
        $this->ChasisNumber->ViewValue = $this->ChasisNumber->CurrentValue;
        $this->ChasisNumber->ViewCustomAttributes = "";

        // Civilian Plate Number
        $this->CivilianPlateNumber->ViewValue = $this->CivilianPlateNumber->CurrentValue;
        $this->CivilianPlateNumber->ViewCustomAttributes = "";

        // Govt Plate Number
        $this->GovtPlateNumber->ViewValue = $this->GovtPlateNumber->CurrentValue;
        $this->GovtPlateNumber->ViewCustomAttributes = "";

        // Custodian_id
        $this->Custodian_id->ViewValue = $this->Custodian_id->CurrentValue;
        $this->Custodian_id->ViewValue = FormatNumber($this->Custodian_id->ViewValue, 0, -2, -2, -2);
        $this->Custodian_id->ViewCustomAttributes = "";

        // Condition_Of_Asset
        $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->CurrentValue;
        $this->Condition_Of_Asset->ViewCustomAttributes = "";

        // Asset_Status
        $this->Asset_Status->ViewValue = $this->Asset_Status->CurrentValue;
        $this->Asset_Status->ViewCustomAttributes = "";

        // #
        $this->_23->LinkCustomAttributes = "";
        $this->_23->HrefValue = "";
        $this->_23->TooltipValue = "";

        // MDA_id
        $this->MDA_id->LinkCustomAttributes = "";
        $this->MDA_id->HrefValue = "";
        $this->MDA_id->TooltipValue = "";

        // Make
        $this->Make->LinkCustomAttributes = "";
        $this->Make->HrefValue = "";
        $this->Make->TooltipValue = "";

        // Model
        $this->Model->LinkCustomAttributes = "";
        $this->Model->HrefValue = "";
        $this->Model->TooltipValue = "";

        // Year of Manufacture
        $this->YearofManufacture->LinkCustomAttributes = "";
        $this->YearofManufacture->HrefValue = "";
        $this->YearofManufacture->TooltipValue = "";

        // Colour
        $this->Colour->LinkCustomAttributes = "";
        $this->Colour->HrefValue = "";
        $this->Colour->TooltipValue = "";

        // Engine Number
        $this->EngineNumber->LinkCustomAttributes = "";
        $this->EngineNumber->HrefValue = "";
        $this->EngineNumber->TooltipValue = "";

        // Chasis Number
        $this->ChasisNumber->LinkCustomAttributes = "";
        $this->ChasisNumber->HrefValue = "";
        $this->ChasisNumber->TooltipValue = "";

        // Civilian Plate Number
        $this->CivilianPlateNumber->LinkCustomAttributes = "";
        $this->CivilianPlateNumber->HrefValue = "";
        $this->CivilianPlateNumber->TooltipValue = "";

        // Govt Plate Number
        $this->GovtPlateNumber->LinkCustomAttributes = "";
        $this->GovtPlateNumber->HrefValue = "";
        $this->GovtPlateNumber->TooltipValue = "";

        // Custodian_id
        $this->Custodian_id->LinkCustomAttributes = "";
        $this->Custodian_id->HrefValue = "";
        $this->Custodian_id->TooltipValue = "";

        // Condition_Of_Asset
        $this->Condition_Of_Asset->LinkCustomAttributes = "";
        $this->Condition_Of_Asset->HrefValue = "";
        $this->Condition_Of_Asset->TooltipValue = "";

        // Asset_Status
        $this->Asset_Status->LinkCustomAttributes = "";
        $this->Asset_Status->HrefValue = "";
        $this->Asset_Status->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // #
        $this->_23->EditAttrs["class"] = "form-control";
        $this->_23->EditCustomAttributes = "";
        $this->_23->EditValue = $this->_23->CurrentValue;
        $this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

        // MDA_id
        $this->MDA_id->EditAttrs["class"] = "form-control";
        $this->MDA_id->EditCustomAttributes = "";
        $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
        $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());

        // Make
        $this->Make->EditAttrs["class"] = "form-control";
        $this->Make->EditCustomAttributes = "";
        if (!$this->Make->Raw) {
            $this->Make->CurrentValue = HtmlDecode($this->Make->CurrentValue);
        }
        $this->Make->EditValue = $this->Make->CurrentValue;
        $this->Make->PlaceHolder = RemoveHtml($this->Make->caption());

        // Model
        $this->Model->EditAttrs["class"] = "form-control";
        $this->Model->EditCustomAttributes = "";
        if (!$this->Model->Raw) {
            $this->Model->CurrentValue = HtmlDecode($this->Model->CurrentValue);
        }
        $this->Model->EditValue = $this->Model->CurrentValue;
        $this->Model->PlaceHolder = RemoveHtml($this->Model->caption());

        // Year of Manufacture
        $this->YearofManufacture->EditAttrs["class"] = "form-control";
        $this->YearofManufacture->EditCustomAttributes = "";
        $this->YearofManufacture->EditValue = $this->YearofManufacture->CurrentValue;
        $this->YearofManufacture->PlaceHolder = RemoveHtml($this->YearofManufacture->caption());

        // Colour
        $this->Colour->EditAttrs["class"] = "form-control";
        $this->Colour->EditCustomAttributes = "";
        if (!$this->Colour->Raw) {
            $this->Colour->CurrentValue = HtmlDecode($this->Colour->CurrentValue);
        }
        $this->Colour->EditValue = $this->Colour->CurrentValue;
        $this->Colour->PlaceHolder = RemoveHtml($this->Colour->caption());

        // Engine Number
        $this->EngineNumber->EditAttrs["class"] = "form-control";
        $this->EngineNumber->EditCustomAttributes = "";
        if (!$this->EngineNumber->Raw) {
            $this->EngineNumber->CurrentValue = HtmlDecode($this->EngineNumber->CurrentValue);
        }
        $this->EngineNumber->EditValue = $this->EngineNumber->CurrentValue;
        $this->EngineNumber->PlaceHolder = RemoveHtml($this->EngineNumber->caption());

        // Chasis Number
        $this->ChasisNumber->EditAttrs["class"] = "form-control";
        $this->ChasisNumber->EditCustomAttributes = "";
        if (!$this->ChasisNumber->Raw) {
            $this->ChasisNumber->CurrentValue = HtmlDecode($this->ChasisNumber->CurrentValue);
        }
        $this->ChasisNumber->EditValue = $this->ChasisNumber->CurrentValue;
        $this->ChasisNumber->PlaceHolder = RemoveHtml($this->ChasisNumber->caption());

        // Civilian Plate Number
        $this->CivilianPlateNumber->EditAttrs["class"] = "form-control";
        $this->CivilianPlateNumber->EditCustomAttributes = "";
        if (!$this->CivilianPlateNumber->Raw) {
            $this->CivilianPlateNumber->CurrentValue = HtmlDecode($this->CivilianPlateNumber->CurrentValue);
        }
        $this->CivilianPlateNumber->EditValue = $this->CivilianPlateNumber->CurrentValue;
        $this->CivilianPlateNumber->PlaceHolder = RemoveHtml($this->CivilianPlateNumber->caption());

        // Govt Plate Number
        $this->GovtPlateNumber->EditAttrs["class"] = "form-control";
        $this->GovtPlateNumber->EditCustomAttributes = "";
        if (!$this->GovtPlateNumber->Raw) {
            $this->GovtPlateNumber->CurrentValue = HtmlDecode($this->GovtPlateNumber->CurrentValue);
        }
        $this->GovtPlateNumber->EditValue = $this->GovtPlateNumber->CurrentValue;
        $this->GovtPlateNumber->PlaceHolder = RemoveHtml($this->GovtPlateNumber->caption());

        // Custodian_id
        $this->Custodian_id->EditAttrs["class"] = "form-control";
        $this->Custodian_id->EditCustomAttributes = "";
        $this->Custodian_id->EditValue = $this->Custodian_id->CurrentValue;
        $this->Custodian_id->PlaceHolder = RemoveHtml($this->Custodian_id->caption());

        // Condition_Of_Asset
        $this->Condition_Of_Asset->EditAttrs["class"] = "form-control";
        $this->Condition_Of_Asset->EditCustomAttributes = "";
        if (!$this->Condition_Of_Asset->Raw) {
            $this->Condition_Of_Asset->CurrentValue = HtmlDecode($this->Condition_Of_Asset->CurrentValue);
        }
        $this->Condition_Of_Asset->EditValue = $this->Condition_Of_Asset->CurrentValue;
        $this->Condition_Of_Asset->PlaceHolder = RemoveHtml($this->Condition_Of_Asset->caption());

        // Asset_Status
        $this->Asset_Status->EditAttrs["class"] = "form-control";
        $this->Asset_Status->EditCustomAttributes = "";
        if (!$this->Asset_Status->Raw) {
            $this->Asset_Status->CurrentValue = HtmlDecode($this->Asset_Status->CurrentValue);
        }
        $this->Asset_Status->EditValue = $this->Asset_Status->CurrentValue;
        $this->Asset_Status->PlaceHolder = RemoveHtml($this->Asset_Status->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->_23);
                    $doc->exportCaption($this->MDA_id);
                    $doc->exportCaption($this->Make);
                    $doc->exportCaption($this->Model);
                    $doc->exportCaption($this->YearofManufacture);
                    $doc->exportCaption($this->Colour);
                    $doc->exportCaption($this->EngineNumber);
                    $doc->exportCaption($this->ChasisNumber);
                    $doc->exportCaption($this->CivilianPlateNumber);
                    $doc->exportCaption($this->GovtPlateNumber);
                    $doc->exportCaption($this->Custodian_id);
                    $doc->exportCaption($this->Condition_Of_Asset);
                    $doc->exportCaption($this->Asset_Status);
                } else {
                    $doc->exportCaption($this->_23);
                    $doc->exportCaption($this->MDA_id);
                    $doc->exportCaption($this->Make);
                    $doc->exportCaption($this->Model);
                    $doc->exportCaption($this->YearofManufacture);
                    $doc->exportCaption($this->Colour);
                    $doc->exportCaption($this->EngineNumber);
                    $doc->exportCaption($this->ChasisNumber);
                    $doc->exportCaption($this->CivilianPlateNumber);
                    $doc->exportCaption($this->GovtPlateNumber);
                    $doc->exportCaption($this->Custodian_id);
                    $doc->exportCaption($this->Condition_Of_Asset);
                    $doc->exportCaption($this->Asset_Status);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->_23);
                        $doc->exportField($this->MDA_id);
                        $doc->exportField($this->Make);
                        $doc->exportField($this->Model);
                        $doc->exportField($this->YearofManufacture);
                        $doc->exportField($this->Colour);
                        $doc->exportField($this->EngineNumber);
                        $doc->exportField($this->ChasisNumber);
                        $doc->exportField($this->CivilianPlateNumber);
                        $doc->exportField($this->GovtPlateNumber);
                        $doc->exportField($this->Custodian_id);
                        $doc->exportField($this->Condition_Of_Asset);
                        $doc->exportField($this->Asset_Status);
                    } else {
                        $doc->exportField($this->_23);
                        $doc->exportField($this->MDA_id);
                        $doc->exportField($this->Make);
                        $doc->exportField($this->Model);
                        $doc->exportField($this->YearofManufacture);
                        $doc->exportField($this->Colour);
                        $doc->exportField($this->EngineNumber);
                        $doc->exportField($this->ChasisNumber);
                        $doc->exportField($this->CivilianPlateNumber);
                        $doc->exportField($this->GovtPlateNumber);
                        $doc->exportField($this->Custodian_id);
                        $doc->exportField($this->Condition_Of_Asset);
                        $doc->exportField($this->Asset_Status);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
