//jshint esversion: 9

//sort business
const sortedBusiness = sorter(businessType);

//sort towns
const sortedTowns = sorter(ekTowns);

function sorter(arr) {
  return arr.sort((a, b) => {
    if (arr === businessType) getSortBy = "business_type";
    if (arr === ekTowns) getSortBy = "town";
    let typeA = a[getSortBy].trim().toLowerCase(),
      typeB = b[getSortBy].trim().toLowerCase();
    if (typeA < typeB) return -1; //sort string ascending
    if (typeA > typeB) return 1;
    return 0; //default return value  (no sorting)
  });
}

//map and populate the ui on line 27
const mapBusiness = sortedBusiness.map(
  el => `<option value="${el.business_type}">${el.business_type}</option>`
);

//populate business type to the ui
mapBusiness.forEach(el => (business.innerHTML += el)); //populate to ui

//Event listening to change
document.addEventListener("change", selectChangeHandler, false);

//Change handler
function selectChangeHandler(e) {
  if (e.target === business) {
    handleOption(e.target);
  }

  if (e.target === region) {
    handleOption(e.target);
  }
}

function handleOption(field) {
  fieldType(field);
}

//fields from the form
function fieldType(field) {
  //For business
  if (field === business) {
    businessField(field);
  }

  //For region
  if (field === region) {
    regionField(field);
  }
}

//Business Field
function businessField({ selectedIndex: index }) {
  document.querySelector("#amount").value = "";
  // const {selectedIndex: index } = field;
  if (business.value === "") {
    getRegionReady(false);
    return;
  } else {
    const businessDetails = sortedBusiness[index - 1];
    getRegionReady(true);
    mapregionOptions(businessDetails).forEach(el => (region.innerHTML += el));
  }
}

//Region Field
function regionField({ selectedIndex: index }) {
  // const {selectedIndex: index } = field;
  if (business.value === "") {
    region.disabled = true;
    return;
  }
  displayAmount(index);
}

function getRegionReady(status) {
  region.disabled = !status;
  region.innerHTML = "<option value='' selected>Select location</option>";
}

function mapregionOptions(businessDetails) {
  return sortedTowns.map(el =>
    el.town === "Ado-Ekiti" || el.town === "Ikere-Ekiti"
      ? `<option value = "${businessDetails.reg_urban}">${el.town}</option>`
      : `<option value = "${businessDetails.reg_rural}">${el.town}</option>`
  );
}

function displayAmount(index) {
  const formattedAmount = numberFormatter(region.options[index].value);
  document.querySelector("#amount").value = formattedAmount;
  //"<span>&#8358;</span>" + formattedAmount;
}

function numberFormatter(num) {
  return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}
